# The Blueprint for Mixing

---

<aside>

[Simple Tom](http://thesimpletom.com) 🟥🟧🟨⬜️ v2.2

</aside>

---

# Intro

---

*I suck at writing, but here we are. I am not a professional writer, as you will have ample opportunity to realize for yourself, but I do happen to have amassed considerable practical knowledge about music making and mixing. This book is my attempt at sharing this knowledge, as flawed and as awkward it may be at times. The ideas and techniques, though, will hopefully more than make up for any shortcomings of the text itself. Enjoy!* 

# Emotion

---

You may own thousands of plug-ins, know thousands of techniques, and face thousands of decisions when mixing. To constantly think about which technique or plug-in to use at each step during mixing is nothing short of exhausting.

You need a strategy.

The people who yelled at you, “Use your ears!” are right, but maybe a bit spartan when it comes to providing an actual approach. This is what I aim to do in this book: deliver a framework for mixing where the tools take a back seat, and the emotion of the song takes the lead. We mix music, we don’t just deal with numbers or parade our best compressors. 

I should point out that a mixing process guided by vision and emotion, where the tools take a back seat, doesn’t mean we ignore tools and technique. Quite the opposite: we should know the fundamentals so well that we don’t need to think about them consciously. When a highly technical process is driven by philosophy, it’s a step up.

> And the most surprising thing is that your favorite mixes were made with this mindset: emotion first. Emotion then decided the tools to be used, the reverb size, the mix density, even the final loudness.
> 

I want to make it clear: this is the next level. This is not a downgrade in mixing music or a beginner approach. This is the most advanced someone can be. Like driving a car, you don’t actively think anymore about changing gears, pushing pedals, road signs, or other cars, and you know very well where you’re going.
You just do it instinctively, and you’re doing it right. 

Achieving this level doesn’t come easy, but it’s a concept real enough so it can be shown (I mean it’s not something vaguely philosophical open to infinite interpretations). And if it can be shown, it can be learned. There will be lots of work involved though, so don’t ever fall into being discouraged. Emotion is a human thing. If you’re human, then you can do it. :)

# Taste

---

Writing, producing, mixing, mastering music - all require taste. Now taste is a word that gets thrown around all the time, with the most changing of meanings. And while I am not with the Word Police, I do feel it is essential to define what I mean by taste for the purpose of this book - this will enhance clarity of the message.

> *T**he story of the chicken soup***
> 

The easiest way to explain what I mean by taste for the purpose of this book is to imagine a cook doing work in the kitchen. Let's say he is doing a chicken soup. Now we all know what to expect when we hear that, although there may be variations. The cook knows his ingredients, knows what the final product should taste like - he is not inventing it! He knows the quantities required for each ingredient, the way to cook them, he constantly checks the taste and texture of the soup, and, very importantly, he is able to make timely adjustments to make sure that the final product will be delicious. Flavor too bland? He knows the perfect way to season it. Too salty? He knows the right way to balance things out. You get the picture.

So taste is mainly having a clear idea of what the final product should be like, or sound like, or (in the case of cooking) taste and feel like. Taste refers to one’s informed standards, shaped by references and experience. It’s like having sampled enough good dishes from different world-class chefs to know what a well-made soup should taste like (even before you start cooking your own version).

There will be variations, of course. Different cooks will do versions of the chicken soup, depending on how daring or traditional they want to go, local cuisine, cultural differences. But even those factors influencing the final product should be accounted for if we are to have good taste. Even these differences are part of an all-encompassing taste for the options available. Now to carry out your vision and taste, you obviously  need technical expertise. But that alone will not take you places.

I am not giving readers judgement based opinions on what genre/dish is better. You already know what you like. Our cook will not try to convince you what dish to try or like. But you had better know the ideal parameters and the margins you can play with for the very dish you happen to be trying to make. So if you decided you like sushi, you have sampled enough restaurants, to where now you own a very discerning taste to tell high-end sushi apart from the amateur variety. You know it when a mix is loud, defined, warm and has good dynamics - and you know when it isn't. 

When you set out to work, your taste is clear, your vision of the finished product is there. 
What I don't mean by good taste is claiming pop music is somehow superior to gangsta rap or the other way around, or that gospel rock fans should be banished, although I would like to see at least one of them exiled. :) 

> **Taste has a dual nature**
> 
1. **Visionary, creative, conceptual**. **The ability to know exactly what the final product should be like**.
2. **Refined, analytical, perceptive**. **The ability to detect subtle nuances**. 
From technical details concerning tonal balance, clarity, definition, texture, size and placement, to musical subtleties like discerning minor differences in rhythm, melody, harmony, and the emotional undertones of a piece.

The more refined our taste, the better we can balance a mix and polish the finest details: we can’t mix what we can’t discern. We also can’t mix what we can’t hear - here comes the need for decent monitoring.

> **Can’t stress this enough, taste is essential**.
> 

These two aspects of taste get developed by actually cooking (and learning from the mistakes), but also by tasting other famous cooks’ dishes. 

Luckily for music you don’t need to travel all over the world to sample the greats. You only need to allocate weekly sessions to listen selections of your music collection, and references that your favorite mixing engineers recommend.

By listening sessions I don’t mean you being around background music. I mean dedicated  listening sessions, where you sit in the sweet spot of your speakers and focus on all the audio cues you can possibly discern: vocal texture, modulation, space, mix density, overall tonal balance, transients, the low end control, the energy in the verse and chorus, how the width of the mix changes and many other details. 

You should aim at developing your taste beyond the one of a simple listener. In order to really understand why established artists, producers and mixing engineers are where they are, you need to be able to perceive every little detail in their work. 

Notice what works and why. There will be hot songs with awful mixes. There is a reason they work. Some subtleties (speaking of awesome mixes now) are not apparent after a first listen, or not even after 100 listens. Just be patient. As you gather experience, review the same songs again with new and improved taste. Find out new details and add them to your taste database.

As you can imagine, a cook will not have a reference dish in the kitchen and periodically taste it and compare it with its ongoing dish. The purpose of these listening sessions (and practice as well) is to actually embed the taste of those awesome engineers into our own subconscious (intuition). The “reference” is not external anymore. We become the reference through our taste, refined over and over by continuously engaging in sessions of listening and finishing mixes (or full songs). No more second guessing.

Eventually, every time you make a decision during music production, the only reason for it should be “because that’s how I like it”. Not “because Simple Tom said so”, not because “everyone on the internet says so”. 

> The downsides of an underdeveloped taste may sound familiar
> 

…searching for “secret sauces” and shortcuts, thinking that they don’t have enough plug-ins, or that they didn’t watched enough tutorials. 
Another frustration-generator would be “the secret sauce explorer” mentality: aimlessly slapping “pro techniques” until something works slightly better than what they currently have. Even though a bit improved, in the grand scheme of things it will still sound underwhelming though.

With taste and vision the situation changes completely: they know what they want to achieve, and they will use all the tools at their disposal to make that happen, no matter what. Or, adapt to a working version within their current set of constraints (be it lacking skills, lacking gear/ingredients, being on a deadline etc.).

> The biggest mistake a music producer (mixing engineer) can make, is to stop listening to music and only focusing on producing (mixing).
> 

Even if we end up knowing every little detail of all our tools, without a proper taste to drive our decision-making (when to use them), they are kind of useless. And we can’t mix by numbers, or by step-by-step methods, or by any form of “cooking recipe”. A recipe is just a list ingredients and a rough guide on how to prepare the dish. No guarantee regarding the final taste whatsoever. Just like there isn’t a magic pan to replace the cook, there are no magic tools to tell us how the bass should sit, how the vocals should sound, or how defined the high end should be.

> **Every method or recipe will eventually require using our own taste**
> 

And our own contribution is our vision.

As you will see by the end of the book, all these parts are interconnected and their work together into spiraling up our output.

<aside>

Music listening is critical for constantly developing our taste. 

</aside>

<aside>

Constantly developing our taste is critical for constantly developing our vision. 

</aside>

<aside>

Constantly developing our vision is critical for constantly developing our music production skills.

</aside>

<aside>

Constantly developing our music production skills is critical for constantly developing our music listening skills.

</aside>

# Vision

---

> Taste is the target you can hit with 100% accuracy. Vision is the target only you can see.
> 

In a way, taste is objective. We have plenty of references that reflect and establish any given taste and we also have methods to educate the taste. Our taste reflects our own culture in the field.

Vision on the other hand, is something personal. Vision is that part of you that pushes the culture forward. The part that sees one step ahead and shows the path. If taste was the reason you started, vision is the reason you create.

Vision is built on taste. It is equally important to know inside-out everything about the genre(s) we are working with, as well as to sample from time to time other genres that are not in our scope. These sampling escapades can either broaden our horizon, or reinforce our current taste - sampling outside of our primary focus is never a waste of time.

Vision is taste in action: your unique translation of reference-informed standards into a creative goal. Where taste defines what *great* sounds like, vision defines what *yours* sounds like.

Taste will allow you to do as much as your current technical skills allow. Vision goes one or several steps further into showing you what’s possible. It’s the unique creative goal for each creation. 

> When the taste is underdeveloped or uneducated we end up doing things aimlessly
> 

How many times have you found yourself in the situation of having a mix, knowing that it doesn’t sound right, and yet not knowing what to do to make it better? Or simply having the same issue with the arrangement of a song, for that matter? You just feel stuck and you have no idea why. 

You probably started randomly trying out all the techniques you have ever heard of, and all the plugins that others swear by, only to get a slightly better mix, and yet, underwhelming when compared to other mixes in the same genre/style.

The moment you started randomly trying out techniques and plugins hoping to fix the mix, is when you are pretty much screwed. 

> Imagine you’re playing darts. Let’s say you have no idea what area on the target has the highest value, and you don’t properly know all throwing techniques. You just throw using random techniques. Some darts reach the target, many don’t. You have no idea what area on the target has the biggest value, because you never had the luck to take a perfect shot.
> 

Now, if you step back and read the rules of the game, learn about the bull’s-eye, you have a **clear  vision** regarding what you need to hit. You know the target and you know it so well that even if you had an unmarked circle on the wall, you would know the point zones inside and out.

This dartboard, with its complex points system, represents your final mix. To apply the right techniques and win the game, you must have a pretty good idea about how the mix should sound before you start mixing the song.

The only way to improve your vision (a bit of an unintended pun, as we need actual eyesight for darts) is to cultivate your taste. We absolutely need the ability to perceive the tiniest details and smallest changes related to the craft. Sometimes, an orchestra director knows better than the musician itself how an instruments should sound and where it should be positioned on the stage. A movie director will re-shoot a dialogue until it sounds perfectly natural. Taste is everything.

Just having a vision doesn’t make you a champion - just a supporter from the sidelines at best. You need to work on your **techniques**. I am not good with darts, but let’s assume for a bit there are many, many throwing techniques. These are your EQing, compression, reverb, stereo field manipulation etc. techniques. Now imagine that in the middle of a darts match someone is asking for some time to practice the shot before actually taking the shot. It won’t work. 

That is to say technique training should be done in dedicated training sessions. This is the place to continuously try new techniques and plugins, and learn. During training, you’re building experience, overcoming challenges, coming up with solutions, and transforming well-thought-out working techniques into instincts.

Vision is not always about aiming for perfection at every step in the process, it must be fluid enough to allow things to happen. It’s also about strategy. 

An audio engineer told this story: he was on the set of a David Lynch movie and they noticed after the scene ended that there was a humming noise in the audio, something they would never manage to remove from the dialogue. So he communicated the issue to David Lynch, and he replied something along the lines “don’t worry, we’re going to add more noise later, then”. Point being, even if the first option failed (which would be the technically “perfect” one), the second option can be equally valid.

Applying this to mixing, let’s say I start mixing a song - a pop song. Pop music is usually loud, wide, and crystal clear. Yet, in my mix there are some parts that are poorly recorded, anything but loud, wide and crystal clear. In this case, I will change my target. I’ll adjust the vision (although it may be conflicting with my excellent taste) to something more achievable. I will shape the elements of the mix so that the overall mix makes sense with those poorly recorded parts in it. I will try to clean up what I can and avoid over-polishing the rest of the elements, thus achieving consistency of the mix. A mix where all elements are complementing each other it’s perceived as better sounding than a mix where some elements are polished while others are suboptimal. Many critically acclaimed and chart-topping hits may be deemed as mediocre if placed under scrutiny, yet they do seem to work because the mix engineer somehow found a way to balance things out, while not having access to perfectly-recorded tracks. In this respect, one might say mixing is every bit as much art as it is science. 

So if the recording is not Billboard studio quality, objectively recognize this and mix accordingly. This is a useful skill to have, as it saves a lot of stress down the road.

<aside>

The final mix represents your vision, cultivated through taste. 
The vision is executed through intentional use of technique.

</aside>

# Intention

---

Out in the field, every situation is unique. Maybe there’s another dart in the center of the target, and there’s a very specific technique that needs to be used, in order to hit the bull’s-eye again. 

This ability, to choose the optimal technique to execute the vision (bull’s-eye), is called **intention**. 

When making or mixing a song, intention will reveal a short list of techniques that you already know, that are suited for the task at hand. Instead of trying all the techniques and tools we know and have, we rather choose from a smaller selection representing the best ones. This avoids excessive friction, and keeps us moving forward.

> ***The trap of reverse-engineering***
> 

There is a phase in learning the craft where we try to imitate artists or mixing engineers we admire. We spend a significant amount of time reverse-engineering their work. Then, we start trying to sound like Artist X in Song Y. Or like Mixing Engineer X in Song Y.

While this practice is an essential step in acquiring skills, it reinforces a mindset of doing things in reverse. A mindset of “*how did they do it?*” instead of “*why did they do it?*”. 

I will go into details in the following chapters, but the natural order of things is “*when*” - “*why*” - “*how*”. As you may guess, by reverse-engineering things, we’re instinctively prioritizing the “*how*”.

After much study, we are tempted to pick up random elements that we like from their work and try to integrate them into our current project.

*How did they got the synth so plucky? I want my synth to be that plucky, too!* 

This is the wrong approach. Their train of thought was *not* something along the lines of “*I want this synth to be plucky for absolutely no reason, just because it sounds cool!*”

> None of the artists you admire create from **end** to start.
> 

What I’m trying to say is that although we did a reverse-engineering on their work, the reason that element is the way it is, is because during the mixing it was a very intentional train of thought based on the question why. Something like…

They started with the “*when*”:
*This is the chorus, so we need as much energy as we can infuse*. At this point of the rationale, it doesn’t matter what can be technically achieved - it’s all a concept.

Then they they moved to the “*why*”,

*I need more contrast and energy to complement the vocals, and all I have in this particular part of the song is the bass, kick, a synth and vocals. So what I’m going to do, because I can’t make the kick or bass or the vocal louder, I am going to act on the only element that can be changed: the synth. I am going to accentuate it’s energy, so together with the vocal, they’re going to create a powerful combo. Why do I need a plucky synth? - because more transient sounds more energetic and complements the vocal.*

Finally, followed up with the “*how*” question:
*How can I achieve more energy, what tools can I use for making the synth recording more powerful? Maybe transient designer, maybe a bit of reverb, maybe multiband compression OTT, maybe a bit of EQ, maybe a bit of everything.*

Then they applied the processing until it sounded the way they liked. There were no level numbers, frequencies, or any other ways that could quantify the outcome. Every decision in the mix was based on just taste. And the result was a section of the song that makes sense, where elements are complementing each other and emotion of the song is amplified by every element that plays. 

> Instead of being reactive, switch to being intentional.
> 

Reaction leads us to randomly (without a clear intention) try all the available tools and techniques (”*How did they achieved that?*”)  to achieve something that may not be needed in our mix.

Intention reveals in front of us a neat selection of techniques and tools, all suited for the task at hand: ”*I do my mixes exactly the way I like it, and because I have great taste, they happen to sound awesome, dense and loud!*”.

When every step in making a song is reactive, the friction is huge and you may find yourself stuck in a loop - i try something, the mix sucks, repeat. 

When every step in making a song is intentional, there is almost no friction.

What’s it going to be? 
Playing darts blindfolded or playing darts with your eyes and mind open?

The moment your taste is aligned (through critical listening) with the standard in your genre, you will *intentionally* make music that aligns with the best songs in that genre, and have as a result: similar arrangement, similar tonal balance, similar dynamics and density, similar loudness etc.

See the difference? All the desired outcomes simply occur from an improved approach to the way you create art and your process. You’re not chasing the style, you are the style.

# Loop

---

Mixing is not a linear process. It’s impossible to provide a diagram or a step-by-step approach that would work perfectly every time. It’s impossible to do a single A-Z list of steps and be done with a mix. A kick drum that worked wonders for last week’s track might kill today's project. 

However, there are several **key qualities** that can guide us on how to approach the mix, and this is what I’m trying to present here. Once these concepts are clear, everything else you will ever learn about mixing will fall into one of these categories. Being aware of them will not only help with mixing, but also help you in the future to better choose the relevant information, organize and prioritize what you learn.

> **In a mix everything is related to everything**
> 

There isn’t a “best way” to start a mix. Just start a rough mix from a handful of elements (it can be vocals, drums, instruments, kick + clap + hats + vocals, anything), then circle back to the starting point and revisit all the tracks, and tweak them to fit even better. This revisiting should happen few times only, because there is t**he danger of starting to run inside an endless loop of revisiting and tweaking**.

Example: we first set the vocal, introduce the drums, introduce the lead guitar, then tweak the vocal (now buried in the mix by the other elements), then tweak the drums (because now the vocal masks the kick), then tweak the guitar (now masked by the kick), then back to the vocal (now masked by the guitar) and so on, *in an endless loop*.

If this sounds familiar, it can happen for two reasons: either your approach to mixing is flawed (this can be fixed by tweaking the approach), or mixing is not matched with your current technical ability, which means you need to improve your technical skills. Even though your taste can feel the mix is not right, your technical ability can’t deliver more (this gets improved with practice).

Learn to recognize this limit, and stop wasting extra mixing time when you reach this point. Next mix will be better. We don’t really learn by endlessly tweaking a single mix, but by doing many mixes and learning something new by finishing each one.

> To avoid the loop, **we must set “anchors” as we progress with the mix**.
> 

Example: a kick drum can only be so loud. Anything more will trigger the limiter. So once we anchor the kick (we set the kick drum at an optimal level, and keep it there), any other sound should not mask or overpower the kick drum. We start building the mix around the anchor.
If a newly introduced element is masking the kick, but at the same time when is turned down (and not masking the kick) it sounds weak, we have to do anything we can (except for raising volume) to make it sound powerful enough: more width, maybe saturation, maybe a bit of midrange presence. 

This is why I say that techniques should have a back seat, and let vision and intention be the main drivers. We hear the issue, we envision what we should hear, and we search for the solution. Every context is unique, and there’s no magical plugin that can solve all the problems. We only have issues with a track when we perceive the issue in the context of the mix (not in solo).

As I mentioned, we can start mixing from anywhere: the vocals, the drum kit, a handful of key instruments. Once we have a good, balanced mix for whatever we chose to start with (the anchors), every other sound that gets introduced into the mix needs to fit the existing sounds.

Once we identify the issue, we can pick the appropriate technique to fix it. The most common techniques are: volume, EQ, panning, reverb, delay, chorus, dynamics, saturation, and you can play with any number of combination of these.

After all the tracks are introduced into the mix (no more muted channels), we do a second pass. Small tweaks to every track in the mix, to make everything sound even tighter and clearer, like a monolith. This pass and the next ones will be the place where we start automating small eq tweaks, or gain rides, to manually fix any masking that prevents the element(s) in focus to shine. Maybe the instruments are masking vocal syllables - this kind of small things. 

Pass through the entire mix by looping every 4-bar segment, while listening and doing the necessary tweaks to make everything sound balanced and clear. Prioritize what you want to hear during each 4-bar section, and make it happen.

<aside>

If you really strive to become your best possible self at mixing, the only way to get mixes that are perceived as loud and still dynamic is to use small bits of volume and/or EQ automation for the final polishing. 

</aside>

<aside>

My benchmark for mixes is [Serban Ghenea](https://serbanghenea.com/). If you start paying attention to (most of) his mixes, you’ll notice a tasteful tonal balance, vocal clarity, and great space management in the mix, which is rarely matched by other engineers.

</aside>

<aside>

Specifically, the aim is to have your ear and taste so well developed, you start hearing the difference between a mix made by using more compression and a mix made by using volume automation to help compression. 

</aside>

<aside>

If we compress everything to the point we won’t need automation, then the final mix will end up sounding over compressed, squashed, a bit sterile. I want to point out that compression itself is not bad as long as it’s used with intention. If you want to sound like Benny Benassy’s Satisfaction, feel free to go bananas with compression.

</aside>

<aside>

Due to the arrangement, the mix will be sparse in some segments, and more dense in others. If we set a heavy-handed compression to keep the tracks under control during the busiest parts, then we punish those tracks during the less busy parts. 

</aside>

> Try to make a clear **distinction** between **utilitarian processing** and **creative processing**, although often times their purposes overlap.
> 

Volume automation to fix issues is utilitarian. Volume automation to create tension is creative. Utilitarian fixes (like volume automation) preserve creative intent; creative choices (like saturation) define the art. One keeps the ship afloat, the other charts its course - but both must work together.

But a room reverb to make a vocal wider for artistic intention purposes, will also make it louder (because it takes more space in the virtual stage). So here, the reverb plays a double role (stereo enhancer and gain), and will probably need a compensation (level adjustment), if the end result (dry sound + reverb) turns out to be too loud. 

Saturation for more grit is creative. Saturation to increase the clarity a sound is on the utilitarian side. 

> **Every creative decision will reflect into the utilitarian side** (it will result in a level change, and/or tonal balance change).
> 

And because the creative part is the most important, when doing utilitarian moves we should try to preserve the creative as much as possible. 

Example: we have a certain texture, timbre and dynamics treatment for the vocal. And the vocal is getting lost in the mix at times. Instead of applying even more compression (that will surely change the qualities of the vocal, in addition to the desired volume leveling effect), we should try first level automation. If this works, we totally preserved the sound and the initial idea. The initial instinct, that’s where the emotion of the performance resides. Try to preserve that as much as possible.

This dual (utilitarian / creative) way of approaching the processing also helps in speeding up decision-making and reduces decision fatigue. By prioritizing creative choices, we narrow down the available tool options to a more manageable amount, instead of randomly testing out techniques. Again, faster decision-making and less decision fatigue. We won’t think about what plugin to use (pick from hundreds), but instead we will think about what *feel* we want to achieve (and therefore narrow down the plugin list).

<aside>

- Because everything is related to everything in a mix, we need to make sure we set anchor elements, to avoid an infinite loop of making endless changes to all elements in the mix.
</aside>

<aside>

- Make a distinction between utilitarian and creative processing, when possible.
</aside>

<aside>

- Compensate for creative processing side-effects with utilitarian decisions, when applicable.
</aside>

<aside>

- The creative choices should lead the way, and utilitarian adjustments should serve only to enhance the mix without altering the original vision.
</aside>

# Qualities

---

When mixing, it is absolutely **vital to mix in context** (all faders up). I can understand it can be hard at first, but we can’t really cook without progressively blending in the ingredients, and once they’re in, they can’t be soloed out, isn’t it? :)

At times, after we’ve identified an issue with a track in the context of the full mix, it may be easier to solo the track and zoom in on the issue. Maybe there’s an unwanted click or a noise. These kind of issues will need audio editing, maybe even RX editing so it makes sense to use the solo when it’s required.

> **For every track (sound)**, **in the context of the mix**, **we have to evaluate the key qualities**: **tonal balance**, **clarity**, **definition**, **texture**, **size**, **placement**.
> 

Every change we make to any one of these qualities will change the way we perceive one or more of the other qualities. Luckily, there is always a couple of aspects that help in taking a decision: **emotion** and **context**.

Ask yourself, what is the better **feel** for that track, not in the context of the mix, but **in the** **context of the song**? More/less power, thickness, grit, bling, softness? 
Answer this, and you’ll instantly pick, from the qualities list, the one(s) that are more helpful to achieve your vision.

Start with the song’s core emotion - that’s your compass. Then for each element (track), ask: *Which qualities will serve this feeling?* A lonely vocal calls for intimacy (narrow dimension, breathy texture), while euphoric synths might need radiant energy (crisp definition, wide depth). The qualities serve the “vibe”, never the other way around.

## Tonal balance

**How we perceive that sound in the mix, the overall tonal balance**: thin, thick, bright, dull etc. 

Note that even though the sound itself may not actually have that perceived quality in solo, due to how it’s interacting with the rest of the mix (masking and overlap), this is how it gets perceived. 

So if we already have a thick vocal in solo, and in the mix it sounds thin, then making the vocal even thicker is not an option (can’t boost frequencies, can’t saturate anymore)

The obvious thing to do in this case, is to try thinning the other elements, so the vocals will sound thick (as intended) in relation to the rest of the mix. This is one way to deal with frequency masking.

## Clarity

**How easily we identify that sound in the mix**. 

This is strictly human ear related, described by the Equal Loudness Contours (human hearing is most sensitive around 3–4 kHz, making that band perceptually “louder”). Usually it’s a matter of how well a track’s 2-5 kHz range is represented - in frequency content, and volume level. On one hand, a track needs to have frequency content in this range, in order to be easily picked up by the ear. On the other hand, if one or more tracks in the mix are too prominent in this range, they will indeed sound very clear but will also mask the perception of the high end air and low end, so we need to find a balance. This balance varies, depending on the dynamic range (density and loudness) of the mix: the denser and loud a mix is, the more we need to pay attention to 2-5 kHz range.

Following the same example with the vocal, if we can’t do anything to make the 2-5 kHz range more prominent (no more saturation, EQ, level automation), we should slightly massage down (with a bell EQ) every other track in the mix, to allow for our vocal to exhibit the desired perceived clarity. Of course, we should pay attention not to lose the clarity of other elements in the process.

Since I mentioned the Equal Loudness Contours, an important aspect of the clarity is the actual dynamic range of the sound. We only hear a sound clearly when it consistently keeps the same level (in relation to the rest of the mix). In case of a vocal, if the level between different words varies too much, we can lose the clarity for some of the words. In this case, we have to find ways to keep the level consistency throughout the mix - usually achieved with dynamics (limiting, compression) and manual volume automation.

## Definition

**The transients help us identifying and separating the sounds in the mix**. 

They should be more or less uniform across the elements of the song (with the odd exception).
Too sharp transients (for a single element) can make the entire mix sound harsh or sharp. 
Too soft transients will make the mix sound very soft overall, but hard to differentiate the elements.

Definition and clarity go hand in hand, and the sole judge on how to balance them is our taste: do we hear clear and defined? Nothing to process. Do we need more definition? We apply processing until we get the desired result.

## Texture

**The harmonic content, the overtones, provide qualities like** (but not limited to)

- **smoothness** (a harmonious blend of frequencies, without any overtones that may be perceived as harsh), ****
- **grit** (aggressive, raw feel),
- **presence** (impact in the midrange), or
- **warmth** (a subjective sense of richness in the low mids).

The tools that can change the harmonic content are the ones that are non-linear in behavior: saturators first and foremost, EQs or compressors that have baked-in saturation, transient shapers that add subtle distortion to transients, tape emulators which bring analog-style saturation and compression, and even some modulation effects like choruses that can introduce harmonic complexity. 

Additionally, reverb and delay units, particularly those modeled after analog gear, can also add subtle texture to an audio signal, as they tend to introduce nonlinearities in their tails and feedback loops.

## Size

**How big** a sound feels in the mix. **The perception of left-to-right** (width) **and bottom-to-top** (height) relative to the virtual stage.

### Width

The width is the stereo image, usually the result of using time-based effects (reverb, delay, chorus, other widening tools).

### Height

The height is simply the frequency content: if the sound contains frequencies in the entire spectrum and they are properly balanced, we perceive it as a massive sound (bottom-to-top). 
If there are parts missing, we are perceiving it accordingly. 
If we cut the low end, the perception is that the sound is starting at the mid height and going up to the top. 
No top end, the sound is perceived as from the ground to mid height. 
No low end and no top end, and the sound is perceived as an element around mid height.

## Placement

**Where is the sound**  **located** in the virtual stage, in terms of horizontal **position** (left-to-right) and **depth** (front-to-back).

### Position

Where a sound sits horizontally across the stereo field. **The perception of horizontal positioning (left-center-right)**, usually done by panning the element.

### Depth

A sound is perceived as closer to the listener (at the front of the stage) when it has defined transients, prominent high-frequency content, higher level, less or shorter reverb, and less width.

At the opposite end, reduced high-frequency content, softer transients, lower level, more reverb, and more width are qualities that place a sound toward the back of the stage.

The most natural (“convincing”) result comes from adjusting all these characteristics together: softening transients slightly, rolling off some high end, lowering the level, and adding a bit more reverb will reliably place a sound behind the front line of the stage. However, we don’t always chase the natural, so this is not a hard rule.

# Approach

---

I’ll probably say it multiple times inside this little book, but it’s important to be constantly reminded: the reason for a concept-based approach (in any field) is because it’s easier to manage. It avoids decision fatigue. At every point during mixing, we must oversee just six qualities. These are easier to manage than all the tools and techniques we know.

But there’s another hidden little gem: let’s say we want to achieve a certain quality. We make a shortlist of tools and techniques. That shortlist ends up empty. Surprise! We actually lack the technical knowledge to achieve that quality. This is a huge piece of information. Without this approach, the usual way is to slap on all the tools and techniques, hoping that something eventually sticks. Lots of time lost, and little to no results. Sound familiar? 

On the other hand, with this concept-based approach, we discover pretty early that we don’t know how to achieve something. And we won’t randomly try techniques in hopes that something will work. Instead we will use that precious time looking to learn techniques that can do the quality (or set of qualities) we’re after. Or, adapt the project to something that we do know how to achieve. That’s also fine. The main objective is always to finish a project, learn from it, and move forward to the next. We learn the most from multiple different mixes, not by working over and over again on the same mix.

Back to the approach, we have quite the overlap regarding the tools (processing) we use to adjust certain qualities. Almost any tool we use will affect multiple qualities.

The EQ affects tonal balance, clarity, and even depth. 
The saturator, in addition to adding texture, will invariably change the tonal balance and clarity, and in some cases, depth (by warming up a signal, we reduce the highs).
The room reverb will increase the level of the source, potentially increasing the clarity, and  affecting the tonal balance as well.

> **For our sanity, it’s a good idea to use the minimum amount of processing that checks multiple boxes required to move forward with our vision for the song.**
> 

The reason I keep on stressing on forming and continuously working on developing our taste, is because eventually we should reach the point where the sole reason for making a decision is “***because this is how I like it***”.

Because we all start by imitating, it can be a difficult step to switch from an imitator mindset (”*I try to copy things from my favorite artists*”) to a creator mindset (”*I do things my way, because that’s how I want my music/mix to sound*”). But without this switch, there is no room for us to grow. We can’t grow by endlessly imitating others.

Transform “*I **should** use the SSL because everyone says it sounds grea*t” into “*I am using the tools that sound best for what I want to achieve. Sometimes Pro-Q works best, sometimes a cheap analog emulation, sometimes Decapitator on default settings.*”.

Transform “*the hats **should** be at -30 dB FS RMS*” into “*the hats are at -27.53 dB FS RMS simply because they sound perfect at that level*”

Transform “t*he mix **should** be at -6 LUFS*” into “*the mix ended up at -6 LUFS during the chorus because I feel that this is the optimal density for this particular mix*”

> **We mix at our best, with efficiency and with minimized second-guessing, the moment we end up driven by our instincts. But we need to make sure that our instincts are educated - and we do that by refining our taste**.
> 

For most commercial music, our taste must overlap with the accepted taste within the community (industry). If our preference is to have the kick and bass 10 dB too loud over the average, we’re going to have a hard time working with anyone within the community. But if, at the same volume level as everyone else, we manage to find a setting that delivers slightly more punch, that’s where we make a difference. Every small detail we can improve, this is where the finest taste comes in.

We all work within the same limitations (20 Hz to 20 kHz and up to 0 dB FS), we all have the same tools, we all know what those tools can do.

<aside>

**The real skill is knowing *when* and *why* to use the tools that everyone else has**

</aside>

With any new element introduced into the mix, we should first think about the role of that sound. What are **the most important two qualities** that the sound must have (*tonal balance, clarity, definition, texture, size, placement*). Prioritize them. Apply the processing to enhance those two qualities, and then listen how that processing affected the rest of the qualities, and, if needed, do the steps to mitigate these side-effects. 

Why just two?
Music is all about creating a certain level of contrast between elements. Each element in the mix will have a couple of dominating features that will set it apart from the other elements.

<aside>

I recently (long after writing the paragraph above) stumbled upon a story of a shoe salesman, very famous for his success. His secret? *Two, not three*. He would present up to two pairs of shoes for the clients to try and choose from. If they asked to try on a third pair, he would say: *Which one of these two would you like me to take away?* 
He learned from practice that often, when customers had a choice of three, they bought none, but when they had a choice of two, they bought one.

The ability to choose the best two qualities is a skill in itself. You’re probably going to get it wrong at first. Don’t worry. We all made the same mistakes. Be sure to make them, so you can learn and become better.

</aside>

> Say I have a piano riff. I want it to be punchy (it’s a main riff, I want impact) and to hit like a wall of sound (I want energy - so wide in all directions, bottom-to-top and left-to-right).
> 

Remember to set your anchors early (kick, vocal, lead - the elements that define the mix’s backbone). This is the foundation that prevents endless loops of tweaking. Every new sound must now serve those anchors, not compete with them.

First, a trick to quickly set the volume of any track in the mix. I pull the volume down to a point where I mostly don’t hear the sound in the mix, then I boost 3-4 dB. This is usually a good ballpark to start with, and will keep adjusting it as I progress with the upcoming processing moves.

Addressing the **punch**. It comes from transients. I can use compression, or multiband compression, or transient shaping. Or even a plucky extra layer. Whatever works. This won’t affect my overall volume too much, but if it does, I adjust the volume, until I get the proportion (between transients and body of the sound) that sounds good in this particular mix.

Once this is done, I move on the the **bottom-to-top size**. With an EQ I’ll make sure it covers the 100-300 Hz (body) up to 2-4 kHz (clarity). Adjust the volume again, if necessary.

Then I’ll move on to **left-to-right width**, with a combination of room reverb, chorus, stereo enhancer. These may slightly change the tonal balance, so I’ll get back to the EQ and make small tweaks. Also, adjust the volume if necessary.

Now, if the sound is still underwhelming at the end of this creative approach, there are utilitarian techniques I can use, to complement the creative decisions. Let’s say I want to go louder, but I am already peaking hot. The next thing to try would be to compress the sound a bit more, until I get some headroom to be able to push it louder. Or apply upward compression. Or apply parallel compression. Or apply parallel saturated compression. And so on. 

<aside>

**When the vision is there, the technique and the tools reveal themselves**

</aside>

Once the creative part is leading, and the vision is strong, the path for what utilitarian techniques to use is already paved. If I have a strong direction, I have little to no guesswork on what tools to use, and it makes it easy for me to go further with the mix.

This is how I do things. This is just one way to do the things. 

But at the end of the day, no matter what everyone else is doing, consciously or not, they still address the **tonal balance, clarity, definition, texture, size** and **placement**. Mixing can quickly become a very messy job, and we must do whatever we can to simplify it as much as possible.

# Process

---

Most online information and all audio marketing are centered around how to do things. The technique. I will call it the “*how*”. And this overwhelmingly huge amount of information is biasing us towards believing that the tools are the most important aspect of music making. We are biased to think that some plugins are better than others. That only certain plugins can do certain things. In the end, instead of us using the tools, the tools are using us. The tools will dictate our story, instead of us using the tools to create our story.

This happens because all we see online is “*how*” to use x plugin. Rarely “*when*” to use it or “*why*” it should be used. It took me some time to unlearn this “*how*-biased YouTube tutorial” mindset, and switch to a mindset that actually makes perfect sense when creating:

> **The actual order in the creative process is** “***when***” → “***why***” → “***how***”.
**Or** **vision** → **intention** → **technique.**
> 

<aside>

“***when***”

</aside>

The **vision**.

The vision tells the story. It’s the strategy: understanding how the energy of the song should evolve and recognizing the moments where texture, contrast, or a shift in tone is necessary to keep the listener engaged. It’s also about deciding when to apply a certain technique or effect depending on the vibe or feeling you're trying to create. 

A train of thought will be: *I have an uplifting, mid-tempo song. I want to convey a bit of intimacy in the intro verse, then I want to build up the energy during the pre-chorus, so I can then have an explosion of energy during the chorus.* 

To continue the example above, for the intro I established I want to convey intimacy. A short room reverb definitely does that. A narrow stereo image works too. A clear and upfront vocal with no doubles and backing could work as well. Instead of facing a situation vaguely labeled as “it doesn’t sound good” and having no idea what do to except for trying random stuff, I now have a clear direction for the intro. 

At this stage I just identify the structure of the story, the emotion of the song, and search for elements to act on - according to the section of the song I’m in. Nothing very technical at this point - if possible, avoid mentioning tools all-together. I may very well not have the technical ability to make it happen - in which case I will come back to this step and see what other secondary strategy may work. 

The beauty of having a vision: it provides options for technical aspects that are unavailable (unknown) and offers the opportunity to come back at this macro level and change other related elements so they keep the story cohesive. This is how sometimes a weird/bad mix can still tell a story and make the song popular: proper vision.

> *- when to use room reverb, narrow imaging, vocals without a vocal doubler?
- among others (because most likely there is no single use for the above), when I want to convey intimacy.*
> 

Similar train of thought when to use a build-up crescendo siren when exiting from a breakdown: when I want to convey tension. Or when to use a low-pass filter in a song: when I want to bring the energy down. And so on. You can start making your own associations between techniques that you already know and emotions or situations in which they are truly shining.

<aside>

“***why***”

</aside>

The **intent**. 

Why are you using a specific tool or effect at a certain point in the mix? This is about understanding the emotional or psychological response you want the listener to have. 

The "*why*" ensures that every choice you make serves the vision of the track. Without this clarity, even the best technical moves are aimless. The "*why*" connects the technical decisions back to the heart of the creative vision, ensuring each element contributes to the overall emotion, story, and impact of the mix.

To continue the example above, I’m now building a short list of plugins and techniques that can do what I need: 2-3 room reverbs that I know and like, an imager (probably on the master, to affect the reverbs aswell), mute all the doubles, doublers effects and background vocals for the intro part.

> *- why use Ozone Imager in mono-maker mode and Valhalla Room?
- because in this case they both help achieving the sense of intimacy required above.*
> 

Similar train of thought for why using a Fairchild compressor on the master - because it’s saturation add a certain warmness that this particular song needs. Or why using Ozone maximizer on an EDM song - because a clean, digital tool works best in this case. By the way, Ozone Vintage Limiter is modeled on Fairchild, and it does sound very distinct. It may saturate too much a mix with already lots of saturation, but it may be exactly what’s needed to rescue a very clean mix that doesn’t complement the actual emotion of the song.

<aside>

”***how***” 

</aside>

The **technique**.

The technical knowledge to make it happen - to be able to implement whatever the “*when*” and “*why*” ask for.

To continue the example above, the technique will include tracks routing, tweaking the plug-ins parameters to get the perfect setting. Here you apply your refined, analytical taste. You’re really dialing in each aspect of the sound until it perfectly complements the mix.

> *- how to use Ozone Imager in mono-maker mode and Valhalla Room?
- I’m using the Imager on the master bus because I want to effect the reverb aswell for that dry and intimate feeling. And for the reverb I will pick the smallest room, no modulation, and the modern algorithm, making it virtually “transparent” so it won’t introduce artifacts that could distract the listener from the vocal performance. Also work on the EQ to really make the reverb sit unnoticed. I will notice it that’s missing if I turn it off though, but the listener can’t do that - so for them it will be truly invisible.*
> 

Yes, we need a quite advanced level of technical knowledge to make things happen on par with our taste. 

# Technique

---

I like to say that a real pro is the one that applies the fundamentals (basics) with 100% accuracy, 100% of the time. 

This is what “advanced” technical knowledge means: knowing the fundamentals inside-out. But at the same time, there are just few basic concepts to master. Everything else (latest and greatest plugins) are just iterations or combinations of these fundamentals. 

<aside>

The fundamentals are: the level (volume fader, panning, EQ), dynamics, distortion, phase interaction between tracks, and time-based processing (reverb, delay, chorus, flanger).

</aside>

Remember: EQ, compression, saturation are never the goal. They’re your tools to shape the qualities that serve the song’s emotion. Master the fundamentals to forget them - like a painter who stops thinking about brushes and just creates.

Yes, you’ll need to spend a certain amount of hours understanding what each one does. If you understand the fundamentals then it would be easy to switch plug-ins or learn new ones, since the working principles are always the same.

> **How to train and improve our technique in a way that complements the creative process**
> 

The technique training should not happen during the actual making of the song. Yes, occasional experimentation (during music making) can be beneficial, but habitually transforming music-making or mixing into a testing ground for plugins, is definitely not a good idea. Because by doing so, we create with no aim, with no vision.

We train and improve our listening skills by doing dedicated listening sessions. The same way, we improve our technical skills by doing dedicated technical testing sessions. 

<aside>

Learning technique is simply applying processing (from mild to extreme) to different sounds, and listening to what happens. Repeated hundreds of times, until we remember it clearly. That’s it.

</aside>

For example, equalize (boost and cut) every frequency with gains between 1 and 30 dB, and various Q values, and listen how each adjustment sounds. This is how we learn to identify how an excess of a certain frequency sounds like, or a lack of a certain frequency sounds like.

Compress sounds with all threshold options, ratios, attack and release settings.

Distort with all available modes.

Apply reverbs long and short. Change pre-delays. Apply chorus. etc.

This is the only way to familiarize with what the different classes of plugins do. And yes, general classes (not brand-specific) will get you very far. 

The main purpose is to learn how each class of plugins affects the qualities: tonal balance, clarity, definition, texture, size, placement. Once you **link these qualities** to corresponding classes of **plugins**, you’re pretty much **unstoppable**.

# Tricks trap

---

Learning just technique (aka “tips & tricks”) without being aware of the road ahead (from beginner to intermediate to mastery) can create a false sense of proficiency. 

Having Jaycen Joshua’s drum bus chain, Josh Gudwin’s vocal chain for Dua Lipa and Chris Gehringer‘s mastering chain for a Grammy-winning song *should* set you up for success, right? I bet you have them already and they don’t work as well as you’d hoped.

But that’s perfectly fine. You are curious and you’re learning. That’s essential in any field. You just need to refine how to use the toolbox.

This is why the ***how*** → ***why*** → ***when*** framework exists. It forces you to think and create a specific context, which in turn narrows your options to a restricted set of solutions. And when the right context appears, Jaycen’s drum bus chain will work flawlessly.

> **Pedro’s Law:** *Any technique you can’t adapt is a handicap.*
> 

Pedro is a fantastic mixing engineer with extraordinary taste. I’m lucky to have him in my circle. We’re working on a small group project. The project is huge. Is the group that’s small. 

He refuses to use any plug-in or chain unless he understands exactly how each component works and why it’s there. His first reason? To gain experience. His second? To reduce dependency on unknown processes. What if that “black box” chain fails on certain audio material? By knowing what each plug-in does, he can swap, disable, or adjust settings to fix it quickly and without headaches.

If you rely on go-to chains but can’t explain how or why they work, or if your mixes sound inconsistent across projects, these are signs you’re using techniques outside their intended context.

Try stripping back. For curiosity’s sake, mix the same song with a limited toolkit (maybe one 
channel strip type across all tracks). Note the problems you encounter. Then rebuild: add only the tools that solve those specific problems. Finally, compare. Remember, *“better”* and *“different”* are not the same thing.

Tricks expire. Taste doesn’t. Keep vision first, and treat tricks as nothing more than tools. Use the right tool for the job and disregard the label: SSL, Neve, Pultec, UAD or DAW stock plug-ins - all become equal in the right hands. When I say *equal* I don’t mean they sound the same. I mean they all serve one single functional purpose: to be used without any “pedigree attachment” when the situation arises.

# Trust the system and yourself

---

We have a story to tell (vision). We use plot twists to enhance it (intention). We use the required tools by vision and intention, to make the story come to life (technique). This is how we tell our story. This is how technique and plugins assist us in telling the story, instead of the other way around.

<aside>

Overall, there must be a balance in terms of developing all components of the creative process

</aside>

- taste: ability to detect the smallest nuances related to the process of music making
- technique: know how various classes of plugins sound, so we can quickly select the best tool for expressing the intention
- intention: know what tool to use to create the desired effect on the listener
- vision: manipulate emotions throughout the song, and create captivating arrangements

> **Every weak link will have specific consequences in the development process**
> 

Without taste, there is no target to aspire to. So we can’t improve our technique. We can only improve what we can hear.

Without technique, we can’t fulfill the requirements of our vision and intention.

Without intention, we just try out random techniques, until something kind of works. But the results are often far from our vision.

Without vision there’s also no intention. What’s left is even more aimless and random experimentation, and the process of making music is profoundly unpleasant, boring, and prone to procrastination.

> **If you prioritize asking yourself** “*when*” and “*why*” (**vision** and **intention**) during music-making sessions, the “*how*” (**technique to use**) **will reveal itself naturally**. But you also need to spend time learning technique.

**If you only focus on learning more and more techniques** (“*how*”), **you will create aimlessly** due to a lack of vision, mostly by random experimentation and influenced by the latest plugin reviews, making it nearly impossible to become a better storyteller.
> 

Pause for a moment, do a reality check, and **focus on strengthening the weakest links**.

And, very important, trust yourself. Blindly. Most of the time you won’t see immediate results, and it’s hard to keep going. That’s your sign to keep going. Because all of a sudden, after many months of daily practice, your productions will suddenly sound radically better. Just blindly trust that the effort will eventually pay off, because it does.

# Stages to mastery

---

## Stage 1. Beginner: The “how” trap

As **beginners**, we are focusing on learning new and interesting techniques - the “how”. From basics like “how a DAW, EQ, or compressor works” to advanced techniques like “how to compress vocals like Grammy winner Max Martin”. 

This mindset can only push us so far, not because of the mimicry involved, but because learning all these techniques are like collecting puzzle pieces without knowing what picture they’re meant to form. Tools are almost meaningless without context.

Without realizing there’s a “why” behind every “how”, we stagnate. There’s never a shortage of new techniques (a new *Mixing With The Masters* episode drops every week, after all), and it’s easy to assume we can’t make the music we want because we “don’t know enough.” So we orbit endlessly at this beginner stage.

## Stage 2. Intermediate: The “why” awakening

The next step is the **intermediate** stage, where we actively seek the “why”. “Why did Max Martin use that specific approach? Why it only work in certain situations?”. 

Here, we understand techniques inside-out and apply them selectively. We shift our focus to intent and emotion. We’re still inspired by other artists, but now we reverse-engineer their decisions, not just their plug-in settings.

Yet, just like the previous stage, it’s easy to get stuck here, forever analyzing others’ work without creating much of our own.

## Stage 3. Mastery: The “when” instinct

True artistic freedom doesn’t come from ignoring rules or music theory. It comes from absorbing the fundamentals so deeply that technique becomes instinct. 

When your song demands urgency, you’ll instinctively know which qualities to amplify: maybe a snare’s sharp definition for punch, or a vocal’s gritty texture for raw intensity. You won’t think *I need 3 dB at 5 kHz*, you’ll think *This needs to smack!*. You do what feels right, even if it defies the often subjective *engineering standards*. Mastery is taste internalized: your instinct is your refined taste in action.

> Beginners collect techniques. Masters own them.
> 

Every decision is intentional and effortless, not because you  know less, but because you've internalized more.

Does this mean abandoning systems? Not at all. At this stage, you'll have powerful workflows: organized templates, refined plugin chains, surgical editing habits. But here's the difference: you ***own*** the system, the system doesn't own you. You understand why each tool works, so you're never at its mercy. These optimized processes exist for one purpose: to eliminate distractions so your full focus can land where it matters: **amplifying the song's emotional impact**.

## Bridging the gaps between each stage

### Stepping from beginner to intermediate

Revisit techniques you’ve learned and replace the mindset: “How did they do this?” with “What problem were they solving?”. 

Start (re)listening your favorite songs critically.

How does the reverb shape the emotion? Is that Lexicon room reverb with compressed tail and EQ cut at 1.5 kHz just “sounding good” or chosen to convey intimacy? It was the settings that made the song or it was the vision and emotion of the song that directly influenced the choice of reverb and settings?

It never starts with the settings. It’s always the vision and emotion that dictate the tools. And that emotion can be achieved with *any* reverb, once you know the space you’re trying to create (intimate or vast).

*Envision* the emotion with songwriting. *Create it* with plug-ins. *Enhance it* with mixing.

### Stepping from intermediate to mastery

> The beginner asks “how?” The intermediate asks “why?” The master just knows “when”.
> 

Each stage serves a purpose, and none can be skipped. 

The key is to keep moving forward: assess your skills, recognize when your mindset needs to shift, and act on it.

At mastery, reverse-engineering ends. You create from vision alone. With fundamentals internalized, there’s nothing you can’t achieve sonically. If you can imagine it, you can do it. You’re no longer “using” techniques; you’re responding to your song’s needs.

I’m being a bit extreme. We never stop learning entirely. But at the mastery stage, the volume of “new” techniques dwindles. Stay open-minded. Test ideas. Discard what doesn’t fit your style. Keep what does.

# Outro

---

*The Blueprint represents the essence of accumulated knowledge after a decade of turning every stone in audio, mixing hundreds of songs, learning and, more importantly, unlearning a ton, failing more times than I can count, and discovering golden nuggets during the process.*

*Thanks for your trust and support, I am truly grateful.
Tom*

---